import React, { Component } from 'react';
import PropTypes from 'prop-types';
import {FormField} from 'react-form';
import classNames from 'classnames';
import {FormText} from "reactstrap";

class SelectWrapper extends Component {

    render() {
        const {
            fieldApi,
            options,
            onChange,
            onBlur,
            placeholder,
            className,
            helpText,
            ...rest
        } = this.props;

        const {
            getValue,
            getError,
            getTouched,
            setValue,
            setTouched
        } = fieldApi;

        const touched = getTouched();
        const error = getError();

        const resolvedOptions = options.find(d => d.value === '') ? options : [
            {
                label: placeholder || 'Seleziona un\'opzione',
                value: '',
                disabled: true
            },
            ...options
        ];

        const nullIndex = resolvedOptions.findIndex(d => d.value === '');
        const selectedIndex = getValue() ? resolvedOptions.findIndex(d => d.value === getValue()): -1;

        return (
            <div>
                <select
                    {...rest}
                    className={classNames(className, {'is-invalid': error && touched})}
                    value={selectedIndex > -1 ? selectedIndex : nullIndex}
                    onChange={(e) => {
                        const val = resolvedOptions[e.target.value].value;
                        setValue(val);
                        if (onChange) {
                            onChange(val, e);
                        }
                    }}
                    onBlur={(e) => {
                        setTouched();
                        if ( onBlur ) {
                            onBlur(e);
                        }
                    }}>
                    {resolvedOptions.map((option, i) => (
                        <option
                            key={option.value}
                            value={i}
                            disabled={option.disabled}>
                            {option.label}
                        </option>
                    ))}
                </select>
                {/*{ error && <div className="invalid-feedback">{error}</div>}*/}
                { helpText && <FormText>{helpText}</FormText>}
            </div>
        );
    }
}

const Select = FormField(SelectWrapper);

Select.propTypes = {
    helpText: PropTypes.string,
};

export default Select;